var k=Object.defineProperty;var C=(e,t,n)=>t in e?k(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n;var w=(e,t,n)=>C(e,typeof t!="symbol"?t+"":t,n);(function(){"use strict";const LOG_LEVELS={debug:0,info:1,warn:2,error:3};let minLevel="debug";const listeners=[];function emit(e,t,n,r){if(LOG_LEVELS[e]<LOG_LEVELS[minLevel])return;const o={timestamp:Date.now(),level:e,source:t,message:n,data:r},a=`[sunwu:${t}]`;switch(e){case"debug":console.debug(a,n,r??"");break;case"info":console.info(a,n,r??"");break;case"warn":console.warn(a,n,r??"");break;case"error":console.error(a,n,r??"");break}for(const s of listeners)try{s(o)}catch{}}function createLogger(e){return{debug:(t,n)=>emit("debug",e,t,n),info:(t,n)=>emit("info",e,t,n),warn:(t,n)=>emit("warn",e,t,n),error:(t,n)=>emit("error",e,t,n)}}const DEFAULT_WS_URL="ws://localhost:9222/extension",WS_RECONNECT_BASE_DELAY=1e3,WS_RECONNECT_MAX_DELAY=3e4,WS_MAX_RECONNECT_ATTEMPTS=10,WS_KEEPALIVE_INTERVAL=2e4,Actions={NAVIGATE:"navigate",SNAPSHOT:"snapshot",GET_TEXT:"get_text",GET_PAGE_STATE:"get_page_state",EXTRACT_TEXT:"extract_text",SCREENSHOT:"screenshot",ANNOTATED_SCREENSHOT:"annotated_screenshot",CLICK:"click",TYPE:"type",FILL:"fill",SCROLL:"scroll",HOVER:"hover",SELECT:"select",PRESS:"press",CHECK:"check",EVALUATE:"evaluate",WAIT:"wait",WAIT_FOR_NETWORK_IDLE:"wait_for_network_idle",GET_URL:"get_url",GET_TITLE:"get_title",TAB_LIST:"tab_list",TAB_OPEN:"tab_open",TAB_CLOSE:"tab_close",TAB_SWITCH:"tab_switch",NETWORK_INTERCEPT:"network_intercept",GET_CONSOLE_LOGS:"get_console_logs"},RpcErrors={METHOD_NOT_FOUND:-32601,ACTION_FAILED:-32e3},InternalMessages={GET_PAGE_STATE:"sunwu:getPageState",ANNOTATE_ELEMENTS:"sunwu:annotateElements",CLEAR_ANNOTATIONS:"sunwu:clearAnnotations",DOM_ACTION:"sunwu:domAction",EXTRACT_TEXT:"sunwu:extractText",PING:"sunwu:ping",SHOW_OVERLAY:"sunwu:showOverlay",HIDE_OVERLAY:"sunwu:hideOverlay",HIGHLIGHT_ELEMENT:"sunwu:highlightElement"},StorageKeys={WS_URL:"sunwu_ws_url",AUTH_TOKEN:"sunwu_auth_token"};function createResponse(e,t){return{jsonrpc:"2.0",id:e,result:t}}function createErrorResponse(e,t,n,r){return{jsonrpc:"2.0",id:e,error:{code:t,message:n,data:r}}}function createNotification(e,t){return{jsonrpc:"2.0",method:e,params:t}}function isRequest(e){return"method"in e&&"id"in e}function isNotification(e){return"method"in e&&!("id"in e)}function parseMessage(e){try{const t=JSON.parse(e);return t.jsonrpc!=="2.0"?null:t}catch{return null}}const log$6=createLogger("ws");class WebSocketClient{constructor(){w(this,"ws",null);w(this,"url",DEFAULT_WS_URL);w(this,"token");w(this,"state","disconnected");w(this,"reconnectAttempts",0);w(this,"reconnectTimer",null);w(this,"keepaliveTimer",null);w(this,"messageHandlers",[]);w(this,"stateHandlers",[])}getState(){return this.state}getUrl(){return this.url}getToken(){return this.token}onMessage(t){this.messageHandlers.push(t)}onStateChange(t){this.stateHandlers.push(t)}setState(t){if(this.state!==t){log$6.info(`Connection state: ${this.state} → ${t}`),this.state=t;for(const n of this.stateHandlers)try{n(t)}catch{}}}connect(t,n){t&&(this.url=t),n!==void 0&&(this.token=n),this.disconnect(!1),this.setState("connecting");try{let r=this.url;const o=new URL(r);(o.pathname==="/"||o.pathname==="")&&(o.pathname="/extension",r=o.toString().replace(/\/$/,""));const a=this.token?`${r}?token=${encodeURIComponent(this.token)}`:r;this.ws=new WebSocket(a)}catch(r){log$6.error("Failed to create WebSocket",r),this.setState("disconnected"),this.scheduleReconnect();return}this.ws.onopen=()=>{log$6.info("Connected to agent server",{url:this.url}),this.setState("connected"),this.reconnectAttempts=0,this.startKeepalive();const r=createNotification("initialize",{extensionVersion:"0.2.0",capabilities:["navigate","snapshot","get_text","click","type","fill","press","check","scroll","hover","select","screenshot","annotated_screenshot","evaluate","wait","wait_for_network_idle","get_url","get_title","tab_list","tab_open","tab_close","tab_switch","get_page_state","extract_text"]});this.send(r)},this.ws.onmessage=r=>{const o=typeof r.data=="string"?r.data:"",a=parseMessage(o);if(!a){log$6.warn("Received unparseable message",{raw:o.slice(0,200)});return}log$6.debug("← Received",a);for(const s of this.messageHandlers)try{s(a)}catch(i){log$6.error("Message handler error",i)}},this.ws.onclose=r=>{if(log$6.info("Connection closed",{code:r.code,reason:r.reason}),this.cleanup(),this.setState("disconnected"),r.code===4010){log$6.warn("Session revoked by relay, not reconnecting");return}this.scheduleReconnect()},this.ws.onerror=r=>{log$6.error("WebSocket error",r)}}disconnect(t=!0){this.reconnectTimer&&(clearTimeout(this.reconnectTimer),this.reconnectTimer=null),t&&(this.reconnectAttempts=WS_MAX_RECONNECT_ATTEMPTS),this.cleanup(),this.setState("disconnected")}send(t){if(!this.ws||this.ws.readyState!==WebSocket.OPEN)return log$6.warn("Cannot send: not connected"),!1;const n=JSON.stringify(t);return log$6.debug("→ Sending",t),this.ws.send(n),!0}cleanup(){this.stopKeepalive(),this.ws&&(this.ws.onopen=null,this.ws.onmessage=null,this.ws.onclose=null,this.ws.onerror=null,(this.ws.readyState===WebSocket.OPEN||this.ws.readyState===WebSocket.CONNECTING)&&this.ws.close(),this.ws=null)}scheduleReconnect(){if(this.reconnectAttempts>=WS_MAX_RECONNECT_ATTEMPTS){log$6.warn("Max reconnect attempts reached");return}const t=Math.min(WS_RECONNECT_BASE_DELAY*Math.pow(2,this.reconnectAttempts),WS_RECONNECT_MAX_DELAY);this.reconnectAttempts++,log$6.info(`Reconnecting in ${t}ms (attempt ${this.reconnectAttempts}/${WS_MAX_RECONNECT_ATTEMPTS})`),this.reconnectTimer=setTimeout(()=>{this.reconnectTimer=null,this.connect()},t)}startKeepalive(){this.stopKeepalive(),this.keepaliveTimer=setInterval(()=>{this.state==="connected"&&this.send(createNotification("ping"))},WS_KEEPALIVE_INTERVAL)}stopKeepalive(){this.keepaliveTimer&&(clearInterval(this.keepaliveTimer),this.keepaliveTimer=null)}}const wsClient=new WebSocketClient,log$5=createLogger("router"),handlers=new Map;function registerHandler(e,t){handlers.set(e,t),log$5.debug(`Registered handler: ${e}`)}function setupMessageRouter(){wsClient.onMessage(async e=>{isRequest(e)?await handleRequest(e):isNotification(e)&&handleNotification(e)})}function broadcastLog(e,t){chrome.runtime.sendMessage({type:"sunwu:log",level:e,message:t}).catch(()=>{})}function summarizeParams(e){if(!e||Object.keys(e).length===0)return"";const t=[];for(const[n,r]of Object.entries(e)){if(r==null)continue;const o=typeof r=="string"?r.length>30?r.slice(0,27)+"...":r:String(r);if(t.push(`${n}=${o}`),t.length>=3){t.push("…");break}}return t.length>0?` (${t.join(", ")})`:""}async function handleRequest(e){const t=handlers.get(e.method);if(!t){log$5.warn(`No handler for method: ${e.method}`),broadcastLog("warn",`Unknown action: ${e.method}`),wsClient.send(createErrorResponse(e.id,RpcErrors.METHOD_NOT_FOUND,`Method not found: ${e.method}`));return}const n=summarizeParams(e.params);broadcastLog("info",`▶ ${e.method}${n}`);const r=Date.now();try{log$5.info(`Executing: ${e.method}`,e.params);const o=await t(e.params??{}),a=Date.now()-r;broadcastLog("info",`✓ ${e.method} (${a}ms)`),wsClient.send(createResponse(e.id,o))}catch(o){const a=o instanceof Error?o.message:String(o),s=Date.now()-r;log$5.error(`Action failed: ${e.method}`,{error:a}),broadcastLog("error",`✗ ${e.method} — ${a} (${s}ms)`),wsClient.send(createErrorResponse(e.id,RpcErrors.ACTION_FAILED,a))}}function handleNotification(e){switch(e.method){case"initialize_ack":log$5.info("Agent acknowledged initialization",e.params);break;case"pong":break;default:log$5.debug(`Received notification: ${e.method}`,e.params)}}const state={activeTabId:null,debuggerAttachedTabs:new Set,consoleLogs:[],recentLogs:[]};function setActiveTab(e){state.activeTabId=e}async function resolveActiveTabId(){if(state.activeTabId)try{return await chrome.tabs.get(state.activeTabId),state.activeTabId}catch{state.activeTabId=null}const[e]=await chrome.tabs.query({active:!0,currentWindow:!0});if(!(e!=null&&e.id))throw new Error("No active tab found");return state.activeTabId=e.id,e.id}const log$4=createLogger("tabs");async function listTabs(){return(await chrome.tabs.query({})).filter(t=>t.id!==void 0).map(t=>({id:t.id,url:t.url||"",title:t.title||"",active:t.active??!1,windowId:t.windowId??0}))}async function openTab(e){log$4.info(`Opening tab: ${e}`);const t=await chrome.tabs.create({url:e,active:!0});if(!t.id)throw new Error("Failed to create tab");setActiveTab(t.id),await waitForTabLoad(t.id);const n=await chrome.tabs.get(t.id);return{id:n.id,url:n.url||"",title:n.title||"",active:n.active??!1,windowId:n.windowId??0}}async function closeTab(e){log$4.info(`Closing tab: ${e}`),await chrome.tabs.remove(e)}async function switchTab(e){log$4.info(`Switching to tab: ${e}`);const t=await chrome.tabs.update(e,{active:!0});if(!t.id)throw new Error("Failed to switch tab");return setActiveTab(t.id),{id:t.id,url:t.url||"",title:t.title||"",active:t.active??!1,windowId:t.windowId??0}}async function navigate(e,t){log$4.info(`Navigating tab ${e} to: ${t}`),await chrome.tabs.update(e,{url:t}),await waitForTabLoad(e)}function waitForTabLoad(e,t=3e4){return new Promise((n,r)=>{const o=setTimeout(()=>{chrome.tabs.onUpdated.removeListener(a),r(new Error("Tab load timeout"))},t),a=(s,i)=>{s===e&&i.status==="complete"&&(clearTimeout(o),chrome.tabs.onUpdated.removeListener(a),n())};chrome.tabs.onUpdated.addListener(a),chrome.tabs.get(e).then(s=>{s.status==="complete"&&(clearTimeout(o),chrome.tabs.onUpdated.removeListener(a),n())})})}const log$3=createLogger("cdp");async function attachDebugger(e){if(!state.debuggerAttachedTabs.has(e))try{await chrome.debugger.attach({tabId:e},"1.3"),state.debuggerAttachedTabs.add(e),log$3.info(`Debugger attached to tab ${e}`)}catch(t){const n=t instanceof Error?t.message:String(t);throw n.includes("Another debugger")?new Error("Another debugger is already attached to this tab. Close DevTools and try again."):new Error(`Failed to attach debugger: ${n}`)}}async function sendCommand(e,t,n){return await attachDebugger(e),await chrome.debugger.sendCommand({tabId:e},t,n)}async function captureScreenshot(e,t="png",n){return(await sendCommand(e,"Page.captureScreenshot",{format:t})).data}async function captureFullPageScreenshot(e,t="png"){const n=await sendCommand(e,"Page.getLayoutMetrics"),{width:r,height:o}=n.contentSize;await sendCommand(e,"Emulation.setDeviceMetricsOverride",{width:Math.ceil(r),height:Math.ceil(o),deviceScaleFactor:1,mobile:!1});const a=await captureScreenshot(e,t);return await sendCommand(e,"Emulation.clearDeviceMetricsOverride"),a}chrome.tabs.onRemoved.addListener(e=>{state.debuggerAttachedTabs.delete(e)}),chrome.debugger.onDetach.addListener(e=>{e.tabId&&(state.debuggerAttachedTabs.delete(e.tabId),log$3.info(`Debugger detached from tab ${e.tabId} (external)`))});const log$2=createLogger("ax-tree"),tabRefMaps=new Map,INTERACTIVE_ROLES=new Set(["link","button","textbox","searchbox","combobox","listbox","option","checkbox","radio","switch","slider","spinbutton","tab","tabpanel","menuitem","menuitemcheckbox","menuitemradio","treeitem","gridcell","row","columnheader","rowheader"]),SKIP_ROLES=new Set(["generic","presentation","none","InlineTextBox","LineBreak"]),SKIP_IF_UNNAMED=new Set(["StaticText","group","paragraph","Section","Div"]);async function getSnapshot(e,t={}){await sendCommand(e,"Accessibility.enable");const r=(await sendCommand(e,"Accessibility.getFullAXTree")).nodes;if(!r||r.length===0)return{text:"- WebArea (empty)",refCount:0};const o=new Map;for(const l of r)o.set(l.nodeId,l);const a=buildTree(r);if(!a)return{text:"- WebArea (empty)",refCount:0};const s=new Map;tabRefMaps.set(e,s);let i=0;const c=[];function u(l,f){var E,v;const{node:h}=l;if(h.ignored){for(const d of l.children)u(d,f);return}const p=((E=h.role)==null?void 0:E.value)??"",m=((v=h.name)==null?void 0:v.value)??"";if(SKIP_ROLES.has(p)){for(const d of l.children)u(d,f);return}if(SKIP_IF_UNNAMED.has(p)&&!m){for(const d of l.children)u(d,f);return}if(p==="StaticText"){if(m&&!t.interactiveOnly){const d="  ".repeat(f);c.push(`${d}- text "${m}"`)}return}const b=INTERACTIVE_ROLES.has(p);if(t.interactiveOnly&&!b){for(const d of l.children)u(d,f);return}let y=`${"  ".repeat(f)}- ${p}`;m&&(y+=` "${m}"`);const T=getDisplayProperties(h);if(T.length>0&&(y+=` (${T.join(", ")})`),b&&h.backendDOMNodeId){const d=`e${i++}`;y+=` [ref=${d}]`,s.set(d,{ref:d,backendDOMNodeId:h.backendDOMNodeId,role:p,name:m})}c.push(y);for(const d of l.children)u(d,f+1)}u(a,0);const g=c.join(`
`);return log$2.info(`Snapshot: ${c.length} lines, ${i} refs`),{text:g,refCount:i}}function lookupRef(e,t){var n;return(n=tabRefMaps.get(e))==null?void 0:n.get(t)}function clearRefMap(e){tabRefMaps.delete(e)}function buildTree(e,t){if(e.length===0)return null;const n=new Map;for(const r of e)n.set(r.nodeId,{node:r,children:[]});for(const r of e){const o=n.get(r.nodeId);if(r.childIds)for(const a of r.childIds){const s=n.get(a);s&&o.children.push(s)}}return n.get(e[0].nodeId)??null}function getDisplayProperties(e){var n;const t=[];if(!e.properties)return t;for(const r of e.properties)switch(r.name){case"focused":r.value.value===!0&&t.push("focused");break;case"checked":r.value.value==="true"||r.value.value===!0?t.push("checked"):r.value.value==="mixed"&&t.push("mixed");break;case"disabled":r.value.value===!0&&t.push("disabled");break;case"expanded":r.value.value===!0?t.push("expanded"):t.push("collapsed");break;case"selected":r.value.value===!0&&t.push("selected");break;case"required":r.value.value===!0&&t.push("required");break;case"readonly":r.value.value===!0&&t.push("readonly");break}if(((n=e.value)==null?void 0:n.value)!==void 0&&e.value.value!==""){const r=String(e.value.value);r.length<=50?t.push(`value="${r}"`):t.push(`value="${r.slice(0,47)}..."`)}return t}chrome.tabs.onRemoved.addListener(e=>{clearRefMap(e)});async function resolveRef(e,t){var o;const n=lookupRef(e,t);if(!n)throw new Error(`Ref "${t}" not found. Run snapshot first.`);await sendCommand(e,"DOM.enable");const r=await sendCommand(e,"DOM.resolveNode",{backendNodeId:n.backendDOMNodeId});if(!((o=r.object)!=null&&o.objectId))throw new Error(`Could not resolve ref "${t}" to a DOM node`);return r.object.objectId}async function callOnElement(e,t,n,r){var s;const o=await resolveRef(e,t),a=await sendCommand(e,"Runtime.callFunctionOn",{objectId:o,functionDeclaration:n,arguments:r??[],returnByValue:!0,awaitPromise:!0});if(a.exceptionDetails){const i=((s=a.exceptionDetails.exception)==null?void 0:s.description)??a.exceptionDetails.text;throw new Error(`JS error on ref "${t}": ${i}`)}return a.result.value}async function getElementBox(e,t){if(!lookupRef(e,t))throw new Error(`Ref "${t}" not found. Run snapshot first.`);await sendCommand(e,"DOM.enable");const r=await sendCommand(e,"DOM.requestNode",{objectId:await resolveRef(e,t)}),a=(await sendCommand(e,"DOM.getBoxModel",{nodeId:r.nodeId})).model.content,s=Math.min(a[0],a[2],a[4],a[6]),i=Math.min(a[1],a[3],a[5],a[7]),c=Math.max(a[0],a[2],a[4],a[6]),u=Math.max(a[1],a[3],a[5],a[7]);return{x:(s+c)/2,y:(i+u)/2,width:c-s,height:u-i}}async function scrollIntoView(e,t){await callOnElement(e,t,`function() {
    this.scrollIntoView({ block: "center", inline: "center" });
  }`)}async function focusElement(e,t){await callOnElement(e,t,`function() {
    this.focus();
  }`)}const log$1=createLogger("actions"),OVERLAY_CSS=`
  @keyframes sunwu-glow-pulse {
    0%, 100% { opacity: 0.7; }
    50% { opacity: 1; }
  }
  @keyframes sunwu-bar-slide-in {
    from { transform: translateX(-50%) translateY(-100%); opacity: 0; }
    to { transform: translateX(-50%) translateY(0); opacity: 1; }
  }
  @keyframes sunwu-dot-pulse {
    0%, 100% { opacity: 0.5; transform: scale(0.85); }
    50% { opacity: 1; transform: scale(1.15); }
  }
  #sunwu-ai-border {
    position: fixed !important;
    inset: -4px !important;
    pointer-events: none !important;
    z-index: 2147483646 !important;
    border: none !important;
    border-radius: 0 !important;
    background: transparent !important;
    box-shadow:
      inset 0 0 16px 8px rgba(70, 130, 255, 0.5),
      inset 0 0 60px 16px rgba(70, 130, 255, 0.25),
      inset 0 0 120px 32px rgba(70, 130, 255, 0.1),
      0 0 16px 8px rgba(70, 130, 255, 0.4),
      0 0 60px 16px rgba(70, 130, 255, 0.2),
      0 0 120px 32px rgba(70, 130, 255, 0.08) !important;
    animation: sunwu-glow-pulse 3s ease-in-out infinite !important;
  }
  #sunwu-ai-bar {
    position: fixed !important;
    top: 10px !important;
    left: 50% !important;
    transform: translateX(-50%) !important;
    z-index: 2147483647 !important;
    pointer-events: none !important;
    display: flex !important;
    align-items: center !important;
    gap: 8px !important;
    padding: 6px 16px !important;
    background: rgba(255, 255, 255, 0.92) !important;
    backdrop-filter: blur(12px) saturate(1.5) !important;
    -webkit-backdrop-filter: blur(12px) saturate(1.5) !important;
    color: #3b5bdb !important;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif !important;
    font-size: 12.5px !important;
    font-weight: 600 !important;
    border-radius: 18px !important;
    border: 1px solid rgba(70, 130, 255, 0.15) !important;
    box-shadow: 0 2px 8px rgba(0,0,0,0.06), 0 0 0 0.5px rgba(70,130,255,0.1) !important;
    animation: sunwu-bar-slide-in 0.25s ease-out !important;
    letter-spacing: 0.2px !important;
    white-space: nowrap !important;
  }
  #sunwu-ai-bar .sunwu-dot {
    width: 7px !important;
    height: 7px !important;
    border-radius: 50% !important;
    background: #4682ff !important;
    box-shadow: 0 0 6px rgba(70,130,255,0.5) !important;
    animation: sunwu-dot-pulse 1.5s ease-in-out infinite !important;
    flex-shrink: 0 !important;
  }
`;async function showOverlay(e){try{await chrome.scripting.insertCSS({target:{tabId:e},css:OVERLAY_CSS}),await chrome.scripting.executeScript({target:{tabId:e},func:()=>{if(document.getElementById("sunwu-ai-border"))return;const t=document.createElement("div");t.id="sunwu-ai-border",document.body.appendChild(t);const n=document.createElement("div");n.id="sunwu-ai-bar",n.innerHTML='<span class="sunwu-dot"></span>Sunwu is browsing',document.body.appendChild(n)}})}catch(t){log$1.debug("showOverlay failed",t)}}async function hideOverlay(e){try{await chrome.scripting.executeScript({target:{tabId:e},func:()=>{var t,n;(t=document.getElementById("sunwu-ai-border"))==null||t.remove(),(n=document.getElementById("sunwu-ai-bar"))==null||n.remove()}})}catch(t){log$1.debug("hideOverlay failed",t)}}async function highlightOnTab(e,t){try{await chrome.scripting.insertCSS({target:{tabId:e},css:`
        @keyframes sunwu-highlight-fade {
          0% { opacity: 0.7; transform: scale(1); }
          100% { opacity: 0; transform: scale(1.04); }
        }
        .sunwu-highlight-ring {
          position: fixed !important;
          pointer-events: none !important;
          z-index: 2147483647 !important;
          border: 2.5px solid #8b5cf6 !important;
          border-radius: 8px !important;
          box-shadow: 0 0 12px rgba(139,92,246,0.5), inset 0 0 6px rgba(139,92,246,0.3) !important;
          background: rgba(139,92,246,0.08) !important;
          animation: sunwu-highlight-fade 0.8s ease-out forwards !important;
        }
      `}),await chrome.scripting.executeScript({target:{tabId:e},func:n=>{let r;if(n.selector){const a=document.querySelector(n.selector);if(!a)return;const s=a.getBoundingClientRect();r={x:s.x,y:s.y,width:s.width,height:s.height}}else if(n.x!==void 0&&n.y!==void 0){const a=n.width??30,s=n.height??30;r={x:n.x-a/2,y:n.y-s/2,width:a,height:s}}else return;const o=document.createElement("div");o.className="sunwu-highlight-ring",o.style.left=`${r.x-4}px`,o.style.top=`${r.y-4}px`,o.style.width=`${r.width+8}px`,o.style.height=`${r.height+8}px`,document.body.appendChild(o),o.addEventListener("animationend",()=>o.remove()),setTimeout(()=>o.remove(),1e3)},args:[t]})}catch(n){log$1.debug("highlightOnTab failed",n)}}async function highlightRef(e,t){try{const n=await getElementBox(e,t);await highlightOnTab(e,{x:n.x,y:n.y,width:n.width,height:n.height})}catch{}}let overlayHideTimer=null;function withOverlay(e){return async t=>{const n=await resolveActiveTabId();overlayHideTimer&&(clearTimeout(overlayHideTimer),overlayHideTimer=null),await showOverlay(n);try{const r=await e(n,t);return overlayHideTimer=setTimeout(()=>{overlayHideTimer=null,hideOverlay(n)},3e3),r}catch(r){throw overlayHideTimer=setTimeout(()=>{overlayHideTimer=null,hideOverlay(n)},3e3),r}}}async function ensureContentScript(e){try{const t=await chrome.tabs.sendMessage(e,{type:InternalMessages.PING});if(t!=null&&t.alive)return}catch{}await chrome.scripting.executeScript({target:{tabId:e},files:["src/content/index.js"]}),await new Promise(t=>setTimeout(t,100))}async function sendToContent(e,t,n){await ensureContentScript(e);const r=await chrome.tabs.sendMessage(e,{type:t,payload:n});if(!r)throw new Error("No response from content script");if(!r.success)throw new Error(r.error||"Content script action failed");return r}function hasRef(e){return typeof e.ref=="string"&&e.ref!==""}async function cdpClick(e,t){await scrollIntoView(e,t);const n=await getElementBox(e,t),r=n.x,o=n.y;await sendCommand(e,"Input.dispatchMouseEvent",{type:"mousePressed",x:r,y:o,button:"left",clickCount:1}),await sendCommand(e,"Input.dispatchMouseEvent",{type:"mouseReleased",x:r,y:o,button:"left",clickCount:1})}const KEY_MAP={Enter:{key:"Enter",code:"Enter",keyCode:13},Tab:{key:"Tab",code:"Tab",keyCode:9},Escape:{key:"Escape",code:"Escape",keyCode:27},Backspace:{key:"Backspace",code:"Backspace",keyCode:8},Delete:{key:"Delete",code:"Delete",keyCode:46},ArrowUp:{key:"ArrowUp",code:"ArrowUp",keyCode:38},ArrowDown:{key:"ArrowDown",code:"ArrowDown",keyCode:40},ArrowLeft:{key:"ArrowLeft",code:"ArrowLeft",keyCode:37},ArrowRight:{key:"ArrowRight",code:"ArrowRight",keyCode:39},Home:{key:"Home",code:"Home",keyCode:36},End:{key:"End",code:"End",keyCode:35},PageUp:{key:"PageUp",code:"PageUp",keyCode:33},PageDown:{key:"PageDown",code:"PageDown",keyCode:34},Space:{key:" ",code:"Space",keyCode:32}," ":{key:" ",code:"Space",keyCode:32}};function parseKeyCombo(e){const t=e.split("+");let n=0,r=t[t.length-1];for(let a=0;a<t.length-1;a++){const s=t[a].toLowerCase();s==="control"||s==="ctrl"?n|=2:s==="alt"?n|=1:s==="shift"?n|=8:(s==="meta"||s==="command"||s==="cmd")&&(n|=4)}const o=KEY_MAP[r];if(o)return{modifiers:n,keyInfo:o};if(r.length===1){const a=r.toUpperCase(),s=a.charCodeAt(0);return{modifiers:n,keyInfo:{key:r,code:`Key${a}`,keyCode:s},text:r}}return{modifiers:n,keyInfo:{key:r,code:r,keyCode:0}}}function registerActionHandlers(){registerHandler(Actions.NAVIGATE,withOverlay(async(e,t)=>{const n=t.url;if(!n)throw new Error("Missing required parameter: url");return await navigate(e,n),await showOverlay(e),{url:n,tabId:e}})),registerHandler(Actions.SNAPSHOT,async e=>{const t=await resolveActiveTabId(),n=e.interactive_only,r=await chrome.tabs.get(t),{text:o,refCount:a}=await getSnapshot(t,{interactiveOnly:n??!1});return{snapshot:o,url:r.url??"",title:r.title??"",refCount:a}}),registerHandler(Actions.GET_PAGE_STATE,async e=>{const t=await resolveActiveTabId();return(await sendToContent(t,InternalMessages.GET_PAGE_STATE)).data}),registerHandler(Actions.GET_TEXT,async e=>{const t=await resolveActiveTabId();if(hasRef(e))return{text:await callOnElement(t,e.ref,'function() { return this.innerText || this.textContent || ""; }')};const n=e.selector;return(await sendToContent(t,InternalMessages.EXTRACT_TEXT,{selector:n})).data}),registerHandler(Actions.EXTRACT_TEXT,async e=>{const t=await resolveActiveTabId(),n=e.selector;return(await sendToContent(t,InternalMessages.EXTRACT_TEXT,{selector:n})).data}),registerHandler(Actions.GET_URL,async()=>{const e=await resolveActiveTabId();return{url:(await chrome.tabs.get(e)).url??""}}),registerHandler(Actions.GET_TITLE,async()=>{const e=await resolveActiveTabId();return{title:(await chrome.tabs.get(e)).title??""}}),registerHandler(Actions.TAB_LIST,async()=>await listTabs()),registerHandler(Actions.TAB_OPEN,async e=>{const t=e.url;if(!t)throw new Error("Missing required parameter: url");return await openTab(t)}),registerHandler(Actions.TAB_CLOSE,async e=>{const t=e.tabId;if(!t)throw new Error("Missing required parameter: tabId");return await closeTab(t),{closed:t}}),registerHandler(Actions.TAB_SWITCH,async e=>{const t=e.tabId;if(!t)throw new Error("Missing required parameter: tabId");const n=await switchTab(t);return setActiveTab(t),n}),registerHandler(Actions.EVALUATE,async params=>{var e;const js=params.js||params.expression;if(!js)throw new Error("Missing required parameter: js");const tabId=await resolveActiveTabId(),results=await chrome.scripting.executeScript({target:{tabId},func:code=>eval(code),args:[js]});return(e=results[0])==null?void 0:e.result}),registerHandler(Actions.WAIT,async e=>{var r;const t=e.ms,n=e.selector;if(t)return await new Promise(o=>setTimeout(o,t)),{waited:t};if(n){const o=await resolveActiveTabId(),a=e.timeout||1e4;if(!((r=(await chrome.scripting.executeScript({target:{tabId:o},func:(c,u)=>new Promise(g=>{if(document.querySelector(c)){g(!0);return}const l=new MutationObserver(()=>{document.querySelector(c)&&(l.disconnect(),g(!0))});l.observe(document.body,{childList:!0,subtree:!0}),setTimeout(()=>{l.disconnect(),g(!1)},u)}),args:[n,a]}))[0])==null?void 0:r.result))throw new Error(`Timeout waiting for selector: ${n}`);return{found:!0,selector:n}}throw new Error("Missing parameter: ms or selector")}),registerHandler(Actions.WAIT_FOR_NETWORK_IDLE,async e=>{const t=await resolveActiveTabId(),n=e.timeout||1e4,r=e.idle_time||500;await sendCommand(t,"Network.enable");try{await new Promise((o,a)=>{let s=0,i=null;const c=setTimeout(()=>{l(),a(new Error(`Network idle timeout after ${n}ms`))},n),u=()=>{s<=0&&(i=setTimeout(()=>{l(),o()},r))},g=(f,h)=>{f.tabId===t&&(h==="Network.requestWillBeSent"?(s++,i&&(clearTimeout(i),i=null)):(h==="Network.loadingFinished"||h==="Network.loadingFailed")&&(s=Math.max(0,s-1),u()))},l=()=>{clearTimeout(c),i&&clearTimeout(i),chrome.debugger.onEvent.removeListener(g)};chrome.debugger.onEvent.addListener(g),u()})}finally{await sendCommand(t,"Network.disable").catch(()=>{})}return{idle:!0}}),registerHandler(Actions.CLICK,withOverlay(async(e,t)=>{if(hasRef(t)){const r=t.ref;return await highlightRef(e,r),await cdpClick(e,r),{clicked:!0,ref:r}}return t.selector&&await highlightOnTab(e,{selector:t.selector}),(await sendToContent(e,InternalMessages.DOM_ACTION,{action:"click",...t})).data})),registerHandler(Actions.TYPE,withOverlay(async(e,t)=>{const n=t.text;if(n===void 0)throw new Error("Missing required parameter: text");if(hasRef(t)){const o=t.ref;await highlightRef(e,o),await focusElement(e,o);for(const a of n)await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyDown",key:a,text:a}),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyUp",key:a});return{typed:!0,text:n}}return t.selector&&await highlightOnTab(e,{selector:t.selector}),(await sendToContent(e,InternalMessages.DOM_ACTION,{action:"type",clear:!1,...t})).data})),registerHandler(Actions.FILL,withOverlay(async(e,t)=>{const n=t.text;if(n===void 0)throw new Error("Missing required parameter: text");if(hasRef(t)){const o=t.ref;await highlightRef(e,o),await focusElement(e,o),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyDown",key:"a",code:"KeyA",modifiers:2}),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyUp",key:"a",code:"KeyA",modifiers:2}),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyDown",key:"Backspace",code:"Backspace"}),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyUp",key:"Backspace",code:"Backspace"});for(const a of n)await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyDown",key:a,text:a}),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyUp",key:a});return{filled:!0,text:n,ref:o}}return t.selector&&await highlightOnTab(e,{selector:t.selector}),(await sendToContent(e,InternalMessages.DOM_ACTION,{action:"type",clear:!0,...t})).data})),registerHandler(Actions.PRESS,withOverlay(async(e,t)=>{const n=t.key;if(!n)throw new Error("Missing required parameter: key");if(hasRef(t)){const s=t.ref;await highlightRef(e,s),await focusElement(e,s)}const{modifiers:r,keyInfo:o,text:a}=parseKeyCombo(n);return await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyDown",key:o.key,code:o.code,windowsVirtualKeyCode:o.keyCode,modifiers:r,text:a}),await sendCommand(e,"Input.dispatchKeyEvent",{type:"keyUp",key:o.key,code:o.code,windowsVirtualKeyCode:o.keyCode,modifiers:r}),{pressed:!0,key:n}})),registerHandler(Actions.CHECK,async e=>{var a;const t=await resolveActiveTabId(),n=e.checked;if(hasRef(e)){const s=e.ref;return await callOnElement(t,s,`function(wantChecked) {
          var el = this;
          // Determine if this is a checkbox/radio input
          if (el.tagName === 'INPUT' && (el.type === 'checkbox' || el.type === 'radio')) {
            if (wantChecked !== undefined && wantChecked !== null) {
              el.checked = wantChecked;
            } else {
              el.checked = !el.checked;
            }
            el.dispatchEvent(new Event('change', { bubbles: true }));
            el.dispatchEvent(new Event('input', { bubbles: true }));
            return { toggled: true, checked: el.checked, tagName: el.tagName };
          }
          // For ARIA switch/checkbox roles, click to toggle
          el.click();
          var isChecked = el.getAttribute('aria-checked') === 'true';
          return { toggled: true, checked: isChecked, tagName: el.tagName };
        }`,[{value:n??null}])}const r=e.selector;if(!r)throw new Error("Missing ref or selector");return(a=(await chrome.scripting.executeScript({target:{tabId:t},func:(s,i)=>{const c=document.querySelector(s);if(!c)throw new Error(`Element not found: ${s}`);return i!==null?c.checked=i:c.checked=!c.checked,c.dispatchEvent(new Event("change",{bubbles:!0})),c.dispatchEvent(new Event("input",{bubbles:!0})),{toggled:!0,checked:c.checked}},args:[r,n??null]}))[0])==null?void 0:a.result}),registerHandler(Actions.SCROLL,withOverlay(async(e,t)=>{if(hasRef(t)){const r=t.ref;return await callOnElement(e,r,'function() { this.scrollIntoView({ behavior: "instant", block: "center" }); }'),{scrolled:!0,ref:r}}return(await sendToContent(e,InternalMessages.DOM_ACTION,{action:"scroll",...t})).data})),registerHandler(Actions.HOVER,withOverlay(async(e,t)=>{if(hasRef(t)){const r=t.ref;await highlightRef(e,r),await scrollIntoView(e,r);const o=await getElementBox(e,r);return await sendCommand(e,"Input.dispatchMouseEvent",{type:"mouseMoved",x:o.x,y:o.y}),{hovered:!0,ref:r}}return t.selector&&await highlightOnTab(e,{selector:t.selector}),(await sendToContent(e,InternalMessages.DOM_ACTION,{action:"hover",...t})).data})),registerHandler(Actions.SELECT,async e=>{const t=await resolveActiveTabId();if(hasRef(e)){const r=e.ref,o=e.value;if(o===void 0)throw new Error("Missing required parameter: value");return await callOnElement(t,r,`function(val) {
          if (this.tagName !== 'SELECT') throw new Error('Target is not a <select>');
          var found = false;
          for (var i = 0; i < this.options.length; i++) {
            if (this.options[i].value === val || this.options[i].textContent.trim() === val) {
              this.value = this.options[i].value;
              found = true;
              break;
            }
          }
          if (!found) throw new Error('Option not found: ' + val);
          this.dispatchEvent(new Event('change', { bubbles: true }));
          this.dispatchEvent(new Event('input', { bubbles: true }));
          return { selected: true, value: this.value };
        }`,[{value:o}])}return(await sendToContent(t,InternalMessages.DOM_ACTION,{action:"select",...e})).data}),registerHandler(Actions.SCREENSHOT,async e=>{const t=await resolveActiveTabId(),n=e.format||"png",r=e.fullPage||!1;let o;return r?o=await captureFullPageScreenshot(t,n):o=await captureScreenshot(t,n),{screenshot:o,format:n}}),registerHandler(Actions.ANNOTATED_SCREENSHOT,async e=>{const t=await resolveActiveTabId(),r=(await sendToContent(t,InternalMessages.ANNOTATE_ELEMENTS)).data;await new Promise(s=>setTimeout(s,100));const o=e.format||"png",a=await captureScreenshot(t,o);return await sendToContent(t,InternalMessages.CLEAR_ANNOTATIONS),{screenshot:a,elements:r,format:o}}),registerHandler(Actions.NETWORK_INTERCEPT,async e=>{throw new Error("Network intercept not yet implemented - requires CDP")}),registerHandler(Actions.GET_CONSOLE_LOGS,async e=>{throw new Error("Console logs not yet implemented - requires CDP")}),log$1.info("All action handlers registered")}const log=createLogger("background");log.info("Sunwu Browser Operator service worker starting"),setupMessageRouter(),registerActionHandlers(),chrome.action.onClicked.addListener(e=>{e.windowId&&chrome.sidePanel.open({windowId:e.windowId})}),chrome.runtime.onMessage.addListener((e,t,n)=>{if(e.type==="sunwu:getConnectionState")return n({state:wsClient.getState(),url:wsClient.getUrl(),token:wsClient.getToken()}),!1;if(e.type==="sunwu:connect"){const r=e.url||DEFAULT_WS_URL,o=e.token;return wsClient.connect(r,o),n({success:!0}),!1}if(e.type==="sunwu:disconnect")return wsClient.disconnect(),n({success:!0}),!1;if(e.type==="sunwu:setToken"){const r=e.token,o=e.url||wsClient.getUrl()||DEFAULT_WS_URL;return log.info("Token injected externally",{token:r,url:o}),chrome.storage.local.set({[StorageKeys.AUTH_TOKEN]:r,[StorageKeys.WS_URL]:o}),wsClient.connect(o,r),n({success:!0}),!1}return!1}),wsClient.onStateChange(async e=>{chrome.runtime.sendMessage({type:"sunwu:connectionStateChanged",state:e,url:wsClient.getUrl(),token:wsClient.getToken()}).catch(()=>{})})})();
